/*
 * Decompiled with CFR 0.152.
 */
package cloud.basis.bci;

import cloud.basis.bci.NestedJarClassLoader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Predicate;

public class NestedJarBCIRunner {
    private static String defaultClassName = "cloud.basis.bci.InstallerRunner";
    private static String defaultMethodName = "main";
    private static boolean debugOn = false;
    public static final Predicate<String> ROOT_INSTALL_JARS = new Predicate<String>(){

        @Override
        public boolean test(String p_t) {
            if (p_t.equals("BCIInstall.jar") || p_t.equals("BASISInstall.jar") || p_t.equals("webforJInstall.jar")) {
                NestedJarBCIRunner.debug("   ==> found ROOT jar: " + p_t);
                return true;
            }
            return false;
        }
    };

    public static void debug(String p_msg) {
        if (debugOn) {
            System.out.println(p_msg);
        }
    }

    public static String getClassToRun() {
        String classToRun = System.getProperty("BCI_RUNNER_CLASS");
        if (classToRun == null || classToRun.length() <= 0) {
            classToRun = defaultClassName;
        }
        return classToRun;
    }

    public static String getMethodToRun() {
        String methodToRun = System.getProperty("BCI_RUNNER_METHOD");
        if (methodToRun == null || methodToRun.length() <= 0) {
            methodToRun = defaultMethodName;
        }
        return methodToRun;
    }

    public static void main(String[] args) {
        NestedJarBCIRunner.debug("NestedJarBCIRunner");
        try {
            NestedJarBCIRunner.debug("-> createNestedJarClassLoader()");
            ClassLoader cl = NestedJarClassLoader.createNestedJarClassLoader(ROOT_INSTALL_JARS.or(NestedJarClassLoader.DEFAULT_NESTED_JAR_PREDICATE));
            Thread.currentThread().setContextClassLoader(cl);
            try {
                String className = NestedJarBCIRunner.getClassToRun();
                Class<?> clazz = null;
                NestedJarBCIRunner.debug("-> get class by name: " + className);
                clazz = Class.forName(className, true, cl);
                String methodName = NestedJarBCIRunner.getMethodToRun();
                NestedJarBCIRunner.debug("-> get class method: " + methodName);
                Method mainMethod = clazz.getMethod(methodName, String[].class);
                mainMethod.setAccessible(true);
                NestedJarBCIRunner.debug("-> invoke class method");
                mainMethod.invoke(null, new Object[]{args});
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                System.err.println("**** **** Caught class not found Exception **** ****");
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
        catch (IOException ioe) {
            System.err.println("**** **** Caught IOException **** ****");
            System.err.println(ioe.getMessage());
            ioe.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            System.err.println("**** **** Caught InvocationTargetException **** ****");
            System.err.println(ite.getMessage());
            ite.printStackTrace();
        }
        catch (Throwable t) {
            System.err.println("**** **** Caught Throwable **** ****");
            System.err.println(t.getMessage());
            t.printStackTrace();
        }
        NestedJarBCIRunner.debug("end of NestedJarBCIRunner");
    }
}

