/*
 * Decompiled with CFR 0.152.
 */
package cloud.basis.bci;

import cloud.basis.bci.OptionSelection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public class NestedJarClassLoader {
    private static final String CLASSLOADER_LOGGING_PROP = "cloud.basis.bci.nested.classloader.logging";
    private static final String CLASSLOADER_LOGGING_ENV = "BCI_NESTED_CLASSLOADER_LOGGING";
    public static final Set<LoggingOption> LOGGING_OPTIONS;
    public static final String TMPDIR_PREFIX = "nestedjars.";
    public static final String TMPDIR_JAR_PREFIX = "nested";
    public static final Predicate<String> JAR_FILE_PREDICATE;
    public static final Predicate<String> DEFAULT_NESTED_JAR_PREDICATE;

    public static ClassLoader createNestedJarClassLoader() throws IOException {
        return NestedJarClassLoader.createNestedJarClassLoader(DEFAULT_NESTED_JAR_PREDICATE);
    }

    public static ClassLoader createNestedJarClassLoader(Predicate<String> p_nestedJarPredicate) throws IOException {
        return NestedJarClassLoader.createNestedJarClassLoader(NestedJarClassLoader.class.getClassLoader(), p_nestedJarPredicate);
    }

    public static ClassLoader createNestedJarClassLoader(ClassLoader p_cl) throws IOException {
        return NestedJarClassLoader.createNestedJarClassLoader(p_cl, DEFAULT_NESTED_JAR_PREDICATE);
    }

    public static ClassLoader createNestedJarClassLoader(ClassLoader p_cl, Predicate<String> p_nestedJarPredicate) throws IOException {
        if (p_cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)p_cl;
            if (LOGGING_OPTIONS.contains((Object)LoggingOption.JARS)) {
                System.out.println("[NestedJarClassLoader] getting classpath from URLClassLoader");
            }
            return NestedJarClassLoader.createNestedJarClassLoader(p_cl, NestedJarClassLoader.deriveJarPaths(ucl.getURLs()), p_nestedJarPredicate);
        }
        if (LOGGING_OPTIONS.contains((Object)LoggingOption.JARS)) {
            System.out.println("[NestedJarClassLoader] using java.class.path System property");
        }
        return NestedJarClassLoader.createNestedJarClassLoader(p_cl, System.getProperty("java.class.path"), p_nestedJarPredicate);
    }

    public static ClassLoader createNestedJarClassLoader(ClassLoader p_parent, String p_classpath) throws IOException {
        return NestedJarClassLoader.createNestedJarClassLoader(p_parent, p_classpath, DEFAULT_NESTED_JAR_PREDICATE);
    }

    public static ClassLoader createNestedJarClassLoader(ClassLoader p_parent, String p_classpath, Predicate<String> p_nestedJarPredicate) throws IOException {
        if (null == p_classpath) {
            p_classpath = "";
        }
        if (LOGGING_OPTIONS.contains((Object)LoggingOption.JARS)) {
            System.out.println("[NestedJarClassLoader] using classpath string: " + p_classpath);
        }
        List<Path> cpp = Arrays.asList(p_classpath.split(File.pathSeparator)).stream().map(s -> Paths.get(s, new String[0])).collect(Collectors.toList());
        return NestedJarClassLoader.createNestedJarClassLoader(p_parent, cpp, p_nestedJarPredicate);
    }

    public static ClassLoader createNestedJarClassLoader(ClassLoader p_parent, List<Path> p_jars) throws IOException {
        return NestedJarClassLoader.createNestedJarClassLoader(p_parent, p_jars, DEFAULT_NESTED_JAR_PREDICATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader createNestedJarClassLoader(ClassLoader p_parent, List<Path> p_jars, Predicate<String> p_nestedJarPredicate) throws IOException {
        URLClassLoader uRLClassLoader;
        block19: {
            Path tmpDir;
            block20: {
                Predicate<String> predicate = null == p_nestedJarPredicate ? DEFAULT_NESTED_JAR_PREDICATE : p_nestedJarPredicate;
                if (LOGGING_OPTIONS.contains((Object)LoggingOption.JARS)) {
                    System.out.println("[NestedJarClassLoader] using jar paths: " + String.valueOf(p_jars));
                }
                tmpDir = Files.createTempDirectory(TMPDIR_PREFIX, new FileAttribute[0]);
                if (LOGGING_OPTIONS.contains((Object)LoggingOption.TMPDIR)) {
                    System.out.println("[NestedJarClassLoader] created temporary directory " + String.valueOf(tmpDir));
                }
                boolean success = false;
                try {
                    ArrayList nested = new ArrayList();
                    for (Path p2 : p_jars) {
                        if (Files.isRegularFile(p2, new LinkOption[0])) {
                            if (LOGGING_OPTIONS.contains((Object)LoggingOption.JARS)) {
                                System.out.println("[NestedJarClassLoader] searching file " + String.valueOf(p2) + " for nested jars");
                            }
                            try (JarFile jf = new JarFile(p2.toFile());){
                                jf.stream().forEach(je -> {
                                    if (predicate.test(je.getName())) {
                                        if (LOGGING_OPTIONS.contains((Object)LoggingOption.NESTED)) {
                                            System.out.println("[NestedJarClassLoader] in " + String.valueOf(p2) + " found nested jar " + je.getName());
                                        }
                                        try (InputStream in = jf.getInputStream((ZipEntry)je);){
                                            Path jarPath = Files.createTempFile(tmpDir, TMPDIR_JAR_PREFIX, ".jar", new FileAttribute[0]);
                                            try (OutputStream out = Files.newOutputStream(jarPath, new OpenOption[0]);){
                                                in.transferTo(out);
                                            }
                                            nested.add(jarPath);
                                        }
                                        catch (IOException io) {
                                            if (LOGGING_OPTIONS.contains((Object)LoggingOption.NESTED)) {
                                                System.out.println("[NestedJarClassLoader] in " + String.valueOf(p2) + " problem reading nested jar " + je.getName());
                                            }
                                            throw new RuntimeException(io);
                                        }
                                    }
                                });
                            }
                            catch (Throwable t) {
                                if (LOGGING_OPTIONS.contains((Object)LoggingOption.JARS)) {
                                    System.out.println("[NestedJarClassLoader] problem reading jar " + String.valueOf(p2));
                                }
                                t.printStackTrace(System.err);
                            }
                            continue;
                        }
                        if (!LOGGING_OPTIONS.contains((Object)LoggingOption.JARS)) continue;
                        System.out.println("[NestedJarClassLoader] " + String.valueOf(p2) + " is not a file");
                    }
                    URL[] urls = nested.stream().map(p -> {
                        try {
                            return p.toUri().toURL();
                        }
                        catch (MalformedURLException e) {
                            return null;
                        }
                    }).filter(u -> null != u).collect(Collectors.toList()).toArray(new URL[nested.size()]);
                    URLClassLoader cl = new URLClassLoader(urls, p_parent);
                    success = true;
                    uRLClassLoader = cl;
                    if (success) {
                        Runtime.getRuntime().addShutdownHook(new Thread("NestedJarClassLoader cleanup", tmpDir){
                            final /* synthetic */ Path val$tmpDir;
                            {
                                this.val$tmpDir = path;
                                super(arg0);
                            }

                            @Override
                            public void run() {
                                try {
                                    if (LOGGING_OPTIONS.contains((Object)LoggingOption.TMPDIR)) {
                                        System.out.println("[NestedJarClassLoader] cleaning up temporary directory on shutdown " + String.valueOf(this.val$tmpDir));
                                    }
                                    NestedJarClassLoader.cleanupDirectory(this.val$tmpDir);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        });
                        break block19;
                    }
                    if (!LOGGING_OPTIONS.contains((Object)LoggingOption.TMPDIR)) break block20;
                    System.out.println("[NestedJarClassLoader] cleaning up temporary directory because of failure " + String.valueOf(tmpDir));
                }
                catch (Throwable throwable) {
                    if (success) {
                        Runtime.getRuntime().addShutdownHook(new /* invalid duplicate definition of identical inner class */);
                    } else {
                        if (LOGGING_OPTIONS.contains((Object)LoggingOption.TMPDIR)) {
                            System.out.println("[NestedJarClassLoader] cleaning up temporary directory because of failure " + String.valueOf(tmpDir));
                        }
                        NestedJarClassLoader.cleanupDirectory(tmpDir);
                    }
                    throw throwable;
                }
            }
            NestedJarClassLoader.cleanupDirectory(tmpDir);
        }
        return uRLClassLoader;
    }

    private NestedJarClassLoader() {
    }

    private static List<Path> deriveJarPaths(URL[] p_urls) {
        if (null == p_urls) {
            return List.of();
        }
        ArrayList<Path> l = new ArrayList<Path>(p_urls.length);
        for (URL u : p_urls) {
            try {
                Path p = Path.of(u.toURI());
                if (!p.getFileName().toString().toLowerCase().endsWith(".jar")) continue;
                l.add(p);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return l;
    }

    private static void cleanupDirectory(Path p_cleanup) throws IOException {
        Files.walkFileTree(p_cleanup, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path p_file, BasicFileAttributes p_attrs) throws IOException {
                Files.delete(p_file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path p_dir, IOException p_exc) throws IOException {
                Files.delete(p_dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static {
        EnumSet options = EnumSet.noneOf(LoggingOption.class);
        try {
            options = OptionSelection.getOptions(LoggingOption.class, (String)CLASSLOADER_LOGGING_PROP, (String)CLASSLOADER_LOGGING_ENV);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOGGING_OPTIONS = Collections.unmodifiableSet(options);
        JAR_FILE_PREDICATE = new Predicate<String>(){

            @Override
            public boolean test(String p_t) {
                if (p_t.toLowerCase().endsWith(".jar")) {
                    if (LOGGING_OPTIONS.contains((Object)LoggingOption.PREDICATE)) {
                        System.out.println("[NestedJarClassLoader] found jar: " + p_t);
                    }
                    return true;
                }
                return false;
            }
        };
        DEFAULT_NESTED_JAR_PREDICATE = JAR_FILE_PREDICATE.and(new Predicate<String>(){

            @Override
            public boolean test(String p_t) {
                if (p_t.startsWith("lib/")) {
                    if (LOGGING_OPTIONS.contains((Object)LoggingOption.PREDICATE)) {
                        System.out.println("[NestedJarClassLoader] jar in lib/: " + p_t);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public static enum LoggingOption {
        JARS,
        NESTED,
        TMPDIR,
        PREDICATE;

    }
}

